
#ifndef _BC7701_H_
#define _BC7701_H_

#include "ht8.h"

/*-------Handware interface define-----------------------------------------*/
#define	BC7701TXD				_pb1
#define	BC7701RXD				_pb2
#define	BC7701RST				_pd6

#define	BC77TRXD					_txr_rxr2
#define	BC77USR					_u2sr
#define	BC77UCR1					_u2cr1
#define	BC77UCR2					_u2cr2
#define	BC77BRG					_brg2
#define	BC77UREN					_uarten2
#define	BC77RXEN					_rxen2
#define	BC77TXEN					_txen2
#define	BC77RXIE					_rie2
#define	BC77RXIF					_rxif2
#define	BC77TXIE					_teie2
#define	BC77TXIF					_txif2
#define	BC77WAKE					_wake2


#define	BC77ISRV					MF5_VECADR
#define	BC77INTE					_ur2e
#define	BC77INTF					_ur2f
#define	BC77MIE					_mf5e
#define	BC77MIF					_mf5f
/*-------------------------------------------------------------------------	
 * BLE Controller Interface(BCI)
 *-------------------------------------------------------------------------*/
/* BCI Header type */
#define	BCI_CMD_PKG				0x77
#define	BCI_EVENT_PKG			0x78

/* BCI OpCode */
#define	BCI_STATUS				0x0000		/* get BC7701 status */
#define	BCI_DISCONNECT			0x0002		/* disconnect current link */
#define	BCI_CONN_INTV			0x0003      /* modify connection interval */
#define	BCI_CONN_INTV1			0x0004      /* modify connection interval */
#define	BCI_DEV_NAME			0x0005      /* setup BLE device name */
#define	BCI_DEV_ADDRESS		0x0006      /* setup BLE device address */
#define	BCI_ADV_CTRL			0x0007      /* enable/disable BLE Adv */
#define	BCI_ADV_INTV			0x0008      /* setup Adv interval */
#define	BCI_ADV_DATA			0x0009      /* setup Adv data */
#define	BCI_SCAN_DATA			0x000A      /* setup scan data */
#define	BCI_TX_POWER			0x000B      /* setup TX power */
#define	BCI_CLOAD_SET			0x000E      /* setup crystal C-Load */
#define	BCI_PEER_DEV_ADDR		0x000F      /* get peer device address of connect */
#define	BCI_FEATURE_CTRL		0x0010      
#define	BCI_VERSION				0x0020      /* get BC7701 F/W version */
#define	BCI_OPERATE_MODE		0x0025      /* set BC7701 operate mode mode */
#define	BCI_BAUDRATE			0x0026      /* setup BC7701 UART interface speed */
#define	BCI_BAUDRATE_MAX		0x0027      /* setup BC7701 UART interface speed to MAX*/
#define	BCI_SOFT_RESET			0x0028      /* BC7701 software reset */
#define	BCI_WHITE_LIST			0x002A      /* setup BC7701 white list */
#define	BCI_TEST_CTRL			0x00CC      /* for BC7701 RF test control */

/* BCI response Event status define */
#define	EVTS_SUCCESS			0x00
#define	EVTS_FAIL				0x01
#define	EVTS_UNKNOW				0x02
#define	EVTS_NOT_SUPPORT		0x03
#define	EVTS_PENDING			0x04
#define	EVTS_INVALID			0x05
#define	EVTS_NOT_ENABLE		0x06
#define	EVTS_TIME_OUT			0x0E
#define	EVTS_CODE_MASK			0x0F

/*------ BC7701 operate mode define ------------------------------------*/
#define	OP_NORMAL				0
#define	OP_DEEPSLEEP         1
#define	OP_POWERDOWN			0x15

/*------ device address type define ------------------------------------*/
#define	STATIC_ADDRESS			0
#define	RANDOM_ADDRESS       1

/*------ set advertising & scan data type ------------------------------*/
#define	UPDAE_AUTO_NAME		0
#define	DEFAULT_NAME       	1
#define	DEFAULT_EMPTY			2
#define	UPDAE_NOAO_NAME		0x10

/*------ BCI package define -------------------------------------------*/
typedef struct
{
	u8		type;
	u8		length;
	u8		flag;
	u16   opcode;
	u8		param[];
}tBCI_PACKAGE;

/*------ status package define -----------------------------------------*/
typedef union
{
	u32	u;
	struct
	{
		u32	Connect:1;
		u32	PramUpdateOk:1;
		u32	PramUpdataFail:1;
		u32	PramUpdataPeer:1;		
		u32 	:4;
		u32	Ext32k:1;
		u32	:23;
	}b;
}tSTATUS;

/*------ device address package define ---------------------------------*/
typedef struct
{
	u8		adr[6];
	u8		type;
}tDEV_ADDR;

/*------ connect interval package define -------------------------------*/
typedef struct
{
	u16	min;
	u16	max;
	u16	latency;
	u16	timeout;
}tCNNT_INTV;

/*------ Advertising interval package define ---------------------------*/
typedef struct
{
	u16	min;
	u16	max;
	u8		map;
}tADV_INTV;

/*------ feature flag package define -----------------------------------*/
#define	FEATURE_DIR			0x00
#define	FEATURE_SET			0x10
#define	FEATURE_CLR			0x20

typedef enum
{
	FEATURE_NO_APPED_NAME =	(1UL << 2),
	FEATURE_PARAM_UPDATE	 =	(1UL << 4),
	FEATURE_PARAM_ERASE	 =	(1UL << 5),
	FEATURE_STATUS_EVENT	 =	(1UL << 7),
	FEATURE_CALIB_DONE	 =	(1UL << 9),
	FEATURE_EXTERNAL32K	 =	(1UL << 12),
	FEATURE_FORCE_CALIB	 =	(1UL << 25),
	FEATURE_CK32K_OUTPUT	 =	(1UL << 28)		
} FeatureFlag;

typedef union
{
	u32	u;
	struct
	{
		u32	:1;
		u32	FFF0Parse:1;
		u32	AppendName:1;
		u32	:1;
		u32	ParaUpdate:1;
		u32	ParaErase:1;
		u32	:1;
		u32	SatusEvent:1;
		u32	CheckExt32k:1;
		u32	CalibDone:1;		
		u32 	:14;
		u32	OnlyFailEvt:1;
		u32	ForceCalib:1;		
		u32	:2;
		u32	CK32Out:3;		
		u32	:1;		
	}b;
}tFEATURE;

/*------ White list package define -------------------------------------*/
typedef struct
{
	u8		adr[6];
	u8		mask[6];
}tWHITE_LIST;

enum
{
   BAUD_RATE_9600 = 0,
   BAUD_RATE_19200,
   BAUD_RATE_25000,
   BAUD_RATE_50000,
   BAUD_RATE_62500,
   BAUD_RATE_115200,
};

/* package parser step define*/ 
enum
{
   PARS_PKG_TYPE = 0x10,
   PARS_HCI_EVENT = 0x60,
   PARS_EVENT_LENG,
	PARS_EVENT_OPCODE,	
   PARS_EVENT_PARAM
};

extern const tBCI_PACKAGE	BC7701_OperateSleep;
extern const tBCI_PACKAGE	BC7701_OperateNormal;
extern const tBCI_PACKAGE	BC7701_PowerDown;
extern const tBCI_PACKAGE	BC7701_AdvertiseEnable;
extern const tBCI_PACKAGE	BC7701_AdvertiseDisable;

#define	BCIPKG(pkg)			((tBCI_PACKAGE *)&pkg)

void 	BC7701_InterfaceConfigure(u8 br);
void 	BC7701_HardwareBaudRateDefault(u8 br);
void 	BC7701_HardwareBaudRateRelease(void);
void 	BC7701_UARTConfigure(u8 br);
void 	BC7701_UARTWakeUpCtrl(u8 ctrl);
void 	BC7701_SoftwareReset(void);
void 	BC7701_SendHCIPackage(u16 opcode,u8 len,u8 *pbuf);
void 	BC7701_SendBCIPackage(u16 opcode,u8 flag,u8 len,u8 *pbuf);
void 	BC7701_SetDeviceName(u8 leng,u8 *name);
void 	BC7701_SetDeviceAddress(u8 *adr,u8 type);
void 	BC7701_ConnectIntervalModify(u16 opcode,u16 min,u16 max);
void 	BC7701_SetAdvertisingData(u8 mode,u8 leng,u8 *advdata);
void 	BC7701_SetScanResponseData(u8 leng,u8 *sdata);
void 	BC7701_AdvertisingInterval(u16 min,u16 max,u8 chmap);
void 	BC7701_AdvertisingControl(u8 ctrl);
void 	BC7701_SetTxPower(u8 pwr);
void 	BC7701_SetCrystalCload(u8 cc);
void 	BC7701_SetupFeatureFlag(u8 md,FeatureFlag sff);
void	BC7701_SetOperateMode(u8 omd,u8 wue,u8 wuw,u8 wut);
void 	BC7701_SetWhiteList(u8 erase,u8 *adr,u8 *mask);
void 	BC7701_SetBaudRate(u8 br);
void 	BC7701_DummyWakeup(u8 leng);
void 	BC7701_TransmitCmdPackage(u16 opcode,u8 flag);
void 	BC7701_TransmitPackage(u8 length);
void 	BC7701_TransmitPackageConst(tBCI_PACKAGE *pkg);
u8 	BC7701_PackageParserProcess(void);
/*------------------------------------------------------------------------------
* Function Name : BC7701_RESET_SET
* Description   : BC7701 reset pin to high
* Input         : None
* Output        : None
* Return        : None
------------------------------------------------------------------------------*/
#define	BC7701_RESET_SET()	(BC7701RST = HIGH)
/*------------------------------------------------------------------------------
* Function Name : BC7701_RESET_CLR
* Description   : BC7701 reset pin to low
* Input         : None
* Output        : None
* Return        : None
------------------------------------------------------------------------------*/
#define	BC7701_RESET_CLR()	(BC7701RST = LOW)

#endif // _BC7701_H_
